from flask import Flask, render_template,request,redirect,flash,url_for, send_from_directory,send_file, Response,session
import pandas as pd
import numpy as np
import os
from flask_mysqldb import MySQL
from werkzeug.utils import secure_filename
from openpyxl import Workbook
from openpyxl.utils import get_column_letter
from io import BytesIO
from datetime import datetime
from fpdf import FPDF
import pymysql
from pymysql.cursors import DictCursor
from reportlab.lib.pagesizes import letter,landscape
from reportlab.platypus import SimpleDocTemplate, Table, TableStyle, Image, Paragraph
from reportlab.lib import colors
from reportlab.lib.styles import ParagraphStyle
from reportlab.lib.enums import TA_CENTER
from datetime import datetime
from reportlab.lib.units import inch
from reportlab.platypus import Spacer
from reportlab.platypus import PageBreak
import textwrap
from reportlab.lib.styles import getSampleStyleSheet
from reportlab.pdfgen import canvas
from reportlab.lib.enums import TA_RIGHT, TA_LEFT
import calendar, locale


app = Flask(__name__, static_url_path='')
ALLOWED_EXTENSIONS = {'pdf','doc'}

def allowed_file(filename):
    return '.' in filename and filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS

UPLOAD_FOLDER = 'static/uploads'
app.config['SECRET_KEY'] = 'super secret key'
app.config['UPLOAD_FOLDER'] = UPLOAD_FOLDER
#KONEKSI DATABASE
app.config['MYSQL_HOST'] = 'localhost'
app.config['MYSQL_USER'] = 'root'
app.config['MYSQL_PASSWORD'] = ''
app.config['MYSQL_DB'] = 'dashboard'
mysql = pymysql.connect(
    host=app.config['MYSQL_HOST'],
    user=app.config['MYSQL_USER'],
    password=app.config['MYSQL_PASSWORD'],
    db=app.config['MYSQL_DB'],
    cursorclass=DictCursor
)

def get_data(sow_id):
    cursor = mysql.cursor()
    cursor.execute("SELECT * FROM dataset WHERE sow_id=?",(sow_id))
    data = cursor.fetchone()
    mysql.commit()
    cursor.close()
    return data

@app.route('/')
def home():
    return render_template('sign.html')

@app.route('/login', methods=['POST'])
def masuk():
    msg = ""
    if request.method == 'POST':
        email = request.form['email']
        password = request.form['pass']
        cursor = mysql.cursor() 
        cursor.execute('SELECT * FROM daftar WHERE email=%s AND password=%s',(email,password))
        account = cursor.fetchone()
        cursor.close()

        if account:
            session['loggedin'] = True
            session['status'] = account['status']

            if account['status'] == 'mitra':
                #session.pop('nama_mitra', None)
                session['nama_mitra'] = account['nama_mitra']
                return redirect('/sign')
            elif account['status'] == 'tsel':
                return redirect('/tsel')
            elif account['status'] == 'tp':
                #session.pop('nama_mitra', None)
                session['nama_tp'] = account['nama_mitra']
                return redirect('/approve')
        else:
            msg = 'Incorrect email/password!'
            return render_template('sign.html',msg=msg)

@app.route('/log', methods=['GET', 'POST'])
def daftar():
    if request.method == 'GET':
        return render_template('daftar.html')
    else:
        data1 = request.form['email']
        data2 = request.form['username']
        data3 = request.form['pass']
        data4 = request.form['radio']

        if data1 and data2 and data3:
            cursor = mysql.cursor()
            
            if data4 == 'mitra':
                nama_mitra = request.form['nama_mitra']
                cursor.execute('''INSERT INTO daftar(email, username, password, status, nama_mitra) 
                                  VALUES(%s, %s, %s, %s, %s)''', (data1, data2, data3, 'mitra', nama_mitra))
            
            elif data4 == 'tp':
                nama_tp = request.form['nama_tp']
                cursor.execute('''INSERT INTO daftar(email, username, password, status, nama_mitra) 
                                  VALUES(%s, %s, %s, %s, %s)''', (data1, data2, data3, 'tp', nama_tp))
            
            mysql.commit()
            cursor.close()
            return render_template('sign.html')
        else:
            flash("Semua field harus diisi!")

    return render_template('daftar.html')


 
@app.route('/sign', methods=['GET','POST'])
def upload_excel():
    nama_mitra = session.get('nama_mitra','')
    if request.method == 'GET':
        cursor = mysql.cursor()
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac FROM dataset WHERE mitra=%s AND action='' ''',(nama_mitra))
        dataset = cursor.fetchall()
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,oac,DATE_FORMAT(tgl, "%d-%m-%Y") AS formatted_date FROM approve WHERE status='approve' ''')
        approve = cursor.fetchall()    
        cursor.close()
        data_tidak_sesuai = []
        for dataset_row in dataset:
            for approve_row in approve:
                if dataset_row['site_id'] == approve_row['site_id'] and \
                    (dataset_row['rf_bfr'], dataset_row['mw_bfr'],dataset_row['rru_bfr']) !=\
                    (approve_row['rf_ud'], approve_row['mw_ud'], approve_row['rru_ud']):
                    dataset_row['highlight'] = True
                    data_tidak_sesuai.append(dataset_row)
                    flash('Data tidak cocok ditemukan!','danger')
                
        return render_template('dashboard.html', data=dataset,data_tidak_sesuai=data_tidak_sesuai)
    else:
        file = request.files['file']
        data = pd.read_excel(file, skiprows=2, usecols=[0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]).fillna(0)
        
        expected_column_count = 15  
        if len(data.columns) != expected_column_count:
            flash('Format data tidak sesuai!', 'danger')
            return redirect('/sign')
        
        
        data.columns = ['SOW ID', 'KKST', 'CAPEX', 'SITE ID', 'SITE NAME', 'OWNER', 'SOW', 'ACTIVITY', 'RF BEFORE', 'MW BEFORE', 'RRU BEFORE', 'RF AFTER', 'MW AFTER', 'RRU AFTER','TGL e-OA']
        with mysql.cursor() as cursor:
            data_to_insert = []

            for _, row in data.iterrows():
                sow_id = row['SOW ID']
                cursor.execute("SELECT sow_id FROM dataset WHERE sow_id=%s", (sow_id,))
                existing_data = cursor.fetchone()

                if existing_data is not None:
                    flash('Data dengan SOW ID {} sudah ada di dalam database. Data ini akan dilewati.'.format(sow_id), 'danger')
                else:
                    data_to_insert.append((
                        sow_id, row['KKST'], row['CAPEX'], row['SITE ID'], row['SITE NAME'],
                        row['OWNER'], row['SOW'], row['ACTIVITY'], row['RF BEFORE'], row['MW BEFORE'],
                        row['RRU BEFORE'], row['RF AFTER'], row['MW AFTER'], row['RRU AFTER'], row['TGL e-OA'], nama_mitra
                    ))

            if data_to_insert:
                insert_query = '''INSERT INTO dataset(sow_id, kkst, capex, site_id, site_name,
                    owner, sow, activity, rf_bfr, mw_bfr, rru_bfr, rf_aft, mw_aft, rru_aft,tgl_oac,mitra)
                    VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s,%s,%s)'''

                cursor.execute("START TRANSACTION")
                cursor.executemany(insert_query, data_to_insert)
                cursor.execute("COMMIT")

        return redirect('/sign')



@app.route('/search', methods=['POST'])
def query_data():
    cursor = mysql.cursor()
    filter = request.form['filter']
    if filter == 'sow':
        sow_id = request.form['keyword']
        cursor.execute("SELECT * FROM dataset WHERE sow_id=%s", (sow_id,))
        data = cursor.fetchall()
        cursor.execute("SELECT * FROM approve WHERE sow_id=%s AND status=%s", (sow_id,"approve"))
        data2 = cursor.fetchall()
    elif filter == 'kkst':
        kkst = request.form['keyword']
        cursor.execute("SELECT * FROM dataset WHERE kkst=%s", (kkst,))
        data = cursor.fetchall()
        cursor.execute("SELECT * FROM approve WHERE kkst=%s AND status=%s", (kkst,"approve"))
        data2 = cursor.fetchall()
    elif filter == 'site_id':
        site_id = request.form['keyword']
        cursor.execute("SELECT * FROM dataset WHERE site_id=%s", (site_id,))
        data = cursor.fetchall()
        cursor.execute("SELECT * FROM approve WHERE site_id=%s AND status=%s", (site_id,"approve"))
        data2 = cursor.fetchall()
    mysql.commit()
    cursor.close()
    data_tidak_sesuai = []
    for dataset_row in data:
        for approve_row in data2:
            if dataset_row['site_id'] == approve_row['site_id'] and \
                    (dataset_row['rf_bfr'], dataset_row['mw_bfr'],dataset_row['rru_bfr']) !=\
                    (approve_row['rf_ud'], approve_row['mw_ud'], approve_row['rru_ud']):
                    dataset_row['highlight'] = True
                    data_tidak_sesuai.append(dataset_row)
    if data:
        return render_template('filter.html', data=data, data2=data2,data_tidak_sesuai=data_tidak_sesuai) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/sign')

@app.route('/searching', methods=['POST'])
def searching():
    filter = request.form['filter']
    nama_tp = session.get('nama_tp','')
    cursor = mysql.cursor()
    if filter == 'sow':
        sow_id = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE sow_id=%s AND status_tp='' ", (sow_id,))
    else:
        kkst = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE kkst=%s AND status_tp='' ", (kkst,))
        
    data2 = cursor.fetchall()
    cursor.execute("SELECT * FROM approve WHERE owner=%s AND status!=''", (nama_tp))
    data = cursor.fetchall()
    mysql.commit()
    cursor.execute("SELECT * FROM approve WHERE owner=%s AND status='approve'", (nama_tp))
    data3 = cursor.fetchall()
    mysql.commit()
    cursor.close()
    if data2:
        pdf_filename = create_pdf(data3)
        return render_template('search_app.html', data=data,data2=data2,pdf_filename=pdf_filename) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/approve')

@app.route('/searchingtsel', methods=['POST'])
def searchingtsel():
    filter = request.form['filter']
    cursor = mysql.cursor()
    if filter == 'sow':
        sow_id = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE sow_id=%s AND status='' AND status_tp='approve' ", (sow_id,))
    else:
        kkst = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE kkst=%s AND status='' status_tp='approve'", (kkst,))
        
    data2 = cursor.fetchall()
    cursor.execute("SELECT * FROM approve WHERE status!='' ")
    data = cursor.fetchall()
    cursor.execute("SELECT * FROM approve WHERE status='approve' ")
    data3 = cursor.fetchall()
    mysql.commit()
    cursor.close()
    if data2:
        pdf_filename = create_pdf(data3)
        return render_template('search_tsel.html', tsel=data,data2=data2,pdf_filename=pdf_filename) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/tsel')
    

@app.route('/search_app', methods=['POST'])
def querys_data():
    nama_tp = session.get('nama_tp','')
    cursor = mysql.cursor()
    #filter_own = request.form['own']
    filter_bulan = request.form['bulan']
    filter_tahun = request.form['tahun']

    bulan_dict = {
        'januari': '01',
        'februari': '02',
        'maret': '03',
        'april': '04',
        'mei': '05',
        'juni': '06',
        'juli': '07',
        'agustus': '08',
        'september': '09',
        'oktober': '10',
        'november': '11',
        'desember': '12' 
    }

    filter_bulan_angka = bulan_dict.get(filter_bulan)

    date_filter = f"{filter_tahun}-{filter_bulan_angka}"
    cursor.execute("SELECT * FROM approve WHERE status=%s AND owner=%s AND DATE_FORMAT(tgl, %s) = %s", ('approve', nama_tp, '%Y-%m', date_filter))
    data = cursor.fetchall()
    cursor.execute("SELECT * FROM approve WHERE status_tp='' AND owner=%s ",(nama_tp))
    data2_tp = cursor.fetchall()
    mysql.commit()
    cursor.close()
    if data:
        pdf_filename = create_pdf(data)
        return render_template('search_app.html', data=data,data2=data2_tp,pdf_filename=pdf_filename) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/approve')


@app.route('/search_tsel', methods=['POST'])
def queris_data():
    cursor = mysql.cursor()
    filter_own = request.form['own']
    filter_bulan = request.form['bulan']
    filter_tahun = request.form['tahun']

    bulan_dict = {
        'januari': '01',
        'februari': '02',
        'maret': '03',
        'april': '04',
        'mei': '05',
        'juni': '06',
        'juli': '07',
        'agustus': '08',
        'september': '09',
        'oktober': '10',
        'november': '11',
        'desember': '12' 
    }

    filter_bulan_angka = bulan_dict.get(filter_bulan)

    date_filter = f"{filter_tahun}-{filter_bulan_angka}"
    cursor.execute("SELECT * FROM approve WHERE status='approve' AND owner=%s AND DATE_FORMAT(tgl,%s) = %s", (filter_own, '%Y-%m',date_filter))
    tsel = cursor.fetchall()
    cursor.execute("SELECT * FROM approve WHERE status='' AND status_tp='approve' ")
    data2 = cursor.fetchall()
    mysql.commit()
    cursor.close()
    if tsel:
        pdf_filename = create_pdf(tsel)
        return render_template('search_tsel.html', tsel=tsel,data2=data2,pdf_filename=pdf_filename) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/tsel')


class AutoPDF(SimpleDocTemplate):
    def auto_cell(self, width, height, text='', border=0, fill=False):
        if fill:
            self.rect(self._x, self._y, width, height, stroke=0, fill=1)
        self.drawString(self._x + 2, self._y + height - 2, text)

def create_pdf(data):
    pdf_filename = 'output.pdf'

    doc = AutoPDF(pdf_filename, pagesize=letter)
    col_widths = [0.68 * inch, 1.0 * inch, 0.65 * inch, 0.6 * inch, 0.7 * inch, 0.5 * inch, 0.55 * inch, 0.7 * inch, 0.35 * inch, 0.35 * inch, 0.35 * inch, 0.35 * inch, 0.35 * inch, 0.35 * inch,0.67 * inch]  # Adjust as needed

    elements = []
    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.alignment = 1 
    for row in data:
        if row['owner'] == 'DMT':
            image = Image('dmt.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'EBT':
            image = Image('ebt.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'PTI':
            image = Image('pti.jpg', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'TBG':
            image = Image('tbg.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'PAB':
            image = Image('pab.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'IBS':
            image = Image('ibs.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'KIN':
            image = Image('kin.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'STP':
            image = Image('stp.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'GMT':
            image = Image('gmt.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'BBT':
            image = Image('bbt.png', width=1 * inch, height=1 * inch)
        elif row['owner'] == 'CMI':
            image = Image('cmi.png', width=1 * inch, height=1 * inch)
        else:
            image = Image('cmi.png', width=1 * inch, height=1 * inch)
        
    image.hAlign = TA_LEFT
    #elements.append(image)

    images = Image('tels.png', width=1.5 * inch, height=1 * inch)
    images.hAlign = TA_RIGHT


    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.alignment = 1 
    style.fontSize = 14

    locale.setlocale(locale.LC_TIME, 'id_ID')

    current_date_d = datetime.now().strftime('%d')
    current_m = datetime.now().strftime('%m')
    current_y = datetime.now().strftime('%Y')
    day_name = calendar.day_name[datetime.now().weekday()]
    month_name = calendar.month_name[int(current_m)]

    text = "Berita Acara Perangkat Terpasang (BAPT)"
    text_paragraph = Paragraph(text, style)

    style_date = ParagraphStyle(name='DateStyle', fontSize=10, alignment=TA_LEFT)
    text_date = f"Pada hari {day_name} tanggal {current_date_d} bulan {month_name} tahun {current_y} yang bertanda tangan dibawah ini :"

    text_date_paragraph = Paragraph(text_date, style_date)

    datas = [[image,text_paragraph, images]]
    tabels = Table(datas, colWidths=[2 * inch, 5 * inch, 1.5 * inch]) 
    
    elements.append(tabels)
    elements.append(Spacer(1, 23)) 
    elements.append(text_date_paragraph)
    elements.append(Spacer(1, 16)) 

    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.alignment = 0 
    style.fontSize = 12

    for row in data:
        if row['owner'] == 'DMT':
            nama2 = "Zulfahmi"
            owner = "PT. DMT"
            jabatan = "Manager"
        elif row['owner'] == 'EBT':
            nama2 = "Zulfahmi"
            owner = "PT. EBT"
            jabatan = "Manager"
        elif row['owner'] == 'PTI':
            nama2 = "Zulfahmi"
            owner = "PT. PTI"
            jabatan = "Manager"
        elif row['owner'] == 'TBG':
            nama2 = "Zulfahmi"
            owner = "PT. TBG"
            jabatan = "Manager"
        elif row['owner'] == 'PAB':
            nama2 = "Zulfahmi"
            owner = "PT. PAB"
            jabatan = "Manager"
        elif row['owner'] == 'IBS':
            nama2 = "Zulfahmi"
            owner = "PT. IBS"
            jabatan = "Manager"
        elif row['owner'] == 'KIN':
            nama2 = "Zulfahmi"
            owner = "PT. KIN"
            jabatan = "Manager"
        elif row['owner'] == 'STP':
            nama2 = "Zulfahmi"
            owner = "PT. STP"
            jabatan = "Manager"
        elif row['owner'] == 'GMT':
            nama2 = "Zulfahmi"
            owner = "PT. GMT"
            jabatan = "Manager"
        elif row['owner'] == 'BBT':
            nama2 = "Zulfahmi"
            owner = "PT. BBT"
            jabatan = "Manager"
        elif row['owner'] == 'CMI':
            nama2 = "Zulfahmi"
            owner = "PT. CMI"
            jabatan = "Manager"
        else:
            owner = "MISSING"
            jabatan = "MISSING"


    #elements.append(text_date_paragraph)
    nama = [["1.","Nama",":","Ardian Widhiyanto"],
            ["","Jabatan",":","Manager RTPD Support Sumbagteng Telkomsel"],
            [""],
            ["2.","Nama",":",nama2],
            ["","Jabatan",":",jabatan]]
    
    tabels2 = Table(nama,colWidths=[0.4 * inch,2 * inch, 0.2 * inch, 4 * inch])
    elements.append(tabels2)

    elements.append(Spacer(1, 15)) 
    teks2 = "Menyatakan bahwa, berdasarkan Colo Application Form (CAF) maka terdapat penambahan atau pengurangan perangkat terpasang pada :"
    teks2 = Paragraph(teks2,style_date)
    elements.append(teks2)
    elements.append(Spacer(1, 25)) 

    table_data = []
    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.leading = 12 
    style.fontSize = 7
    style.alignment = TA_CENTER
    style.fontName = "Helvetica-Bold"

    header = ["Sow ID", "KKST", "Capex", "Site ID", "Site Name", "Owner", "Sow", "Activity", "Rf bfr", "Mw bfr", "Rru bfr", "Rf aft", "Mw aft", "Rru aft","Tgl Approve"]
    header_paragraphs = [Paragraph(header_item, style) for header_item in header]
    table_data.append(header_paragraphs)

    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.leading = 12 
    style.fontSize = 6
    style.alignment = TA_CENTER
    style.fontName = "Helvetica"

    for row in data:
        table_data.append([Paragraph(str(row['sow_id']), style),
                           Paragraph(str(row['kkst']), style),
                           Paragraph(str(row['capex']), style),
                           Paragraph(str(row['site_id']), style),
                           Paragraph(str(row['site_name']), style),
                           Paragraph(str(row['owner']), style),
                           Paragraph(str(row['sow']), style),
                           Paragraph(str(row['activity']), style),
                           Paragraph(str(row['rf_bfr']), style),
                           Paragraph(str(row['mw_bfr']), style),
                           Paragraph(str(row['rru_bfr']), style),
                           Paragraph(str(row['rf_ud']), style),
                           Paragraph(str(row['mw_ud']), style),
                           Paragraph(str(row['rru_ud']), style),
                           Paragraph(str(row['tgl']), style)])

    style = TableStyle([('BACKGROUND', (0, 0), (-1, 0), colors.cornflower),
                        ('TEXTCOLOR', (0, 0), (-1, 0), colors.white),
                        ('ALIGN', (0, 0), (-1, -1), 'CENTER'),
                        ('FONTNAME', (0, 0), (-1, 0), 'Times-Bold'),
                        ('BOTTOMPADDING', (0, 0), (-1, 0), 12),
                        ('BACKGROUND', (0, 1), (-1, 1), colors.white),
                        ('GRID', (0, 0), (-1, -1), 1, colors.black)])
    

    table = Table(table_data, colWidths=col_widths)
    table.setStyle(style)

    elements.append(table)
    elements.append(Spacer(1, 12)) 

    image = Image("ttd.jpg", width=1.5 * inch, height=1 * inch)
    image.hAlign = TA_LEFT 

    #elements.append(image)

    styles = getSampleStyleSheet()
    style = styles["Normal"]
    style.alignment = 0 

    text = ("Ardian Widhiyanto")
    text_name = Paragraph(text,style)

    image2 = Image("ttd2.jpeg",width=1.5 *inch, height=1 * inch)
    image2.hAlign = TA_RIGHT

    style2 = getSampleStyleSheet()
    styles2 = style2["Normal"]
    styles2.alignment = 1
    teks = ('Zulfahmi')
    teks_name = Paragraph(teks,styles2)
    
    datas2 = [["PT. Telekomunikasi Seluler","",owner],
            [image,"",image2],
             [text_name,"",nama2],
             ["Manager RTPD Support Sumbagteng Telkomsel","",jabatan]]
    tabel2 = Table(datas2, colWidths=[2 * inch, 3 * inch, 2 * inch])
    elements.append(Spacer(1, 30)) 
    elements.append(tabel2)

    #elements.append(text_name)
    doc.build(elements)


    return pdf_filename


@app.route('/download_pdf/<pdf_filename>', methods=['GET'])
def download_pdf(pdf_filename):
    response = Response()
    response.headers['Cache-Control'] = 'no-cache'
    response.headers['Content-type'] = 'application/pdf'
    response.headers['Content-Disposition'] = f'inline; filename={pdf_filename}'
    with open(pdf_filename,'rb') as f:
        response.data = f.read()
    return response


@app.route('/up/<sow_id>', methods=['GET','POST'])
def up(sow_id):
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM dataset WHERE sow_id=%s',(sow_id,))
    data = cursor.fetchone()
    if request.method == 'GET':
        return render_template('upload.html', data=data)
    else:
        sow_id = request.form['sow_id']
        kkst = request.form['kkst']
        capex = request.form['capex']
        site_id = request.form['site_id']
        site_name = request.form['site_name']
        owner = request.form['owner']
        sow = request.form['sow']
        activity = request.form['activity']
        rf_bfr = request.form['rf_bfr']
        mw_bfr = request.form['mw_bfr']
        rru_bfr = request.form['rru_bfr']
        rf_aft = request.form['rf_aft']
        mw_aft = request.form['mw_aft']
        rru_aft = request.form['rru_aft']
        rf_ud = request.form['rf_ud']
        mw_ud = request.form['mw_ud']
        rru_ud = request.form['rru_ud']
        tgl_oac = request.form['tgl_oac']
        mitra = request.form['mitra']

        file = request.files['file']
        filename = (secure_filename(f"{sow_id}_{file.filename}")).lower()
        file.save(os.path.join(app.config['UPLOAD_FOLDER'], filename))

        if rf_ud == '0':
            rf_ud = rf_aft
        
        if mw_ud == '0':
            mw_ud = mw_aft
        
        if rru_ud == '0':
            rru_ud = rru_aft

        cursor.execute('UPDATE dataset SET action=%s,rf_ud=%s,mw_ud=%s,rru_ud=%s WHERE sow_id=%s',('approve',rf_ud,mw_ud,rru_ud,sow_id))
        mysql.commit()
        cursor.close()
        
        cursor = mysql.cursor()
        val = url_for('static', filename='uploads/' + filename)
        
        cursor.execute(''' INSERT INTO approve(sow_id,kkst,capex,site_id,site_name,
        owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
        rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,oac,mitra) VALUES (%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)''',(sow_id,kkst,
        capex,site_id,site_name,owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac, val,mitra))

        mysql.commit()
        cursor.close()


        cursor = mysql.cursor()
        cursor.execute('''SELECT * FROM approve''')
        rv = cursor.fetchall()
        mysql.commit()                                       
        cursor.close()
        flash("File berhasil diunggah!",'success')

        return redirect('/sign')


@app.route('/download/<filename>')
def download(filename):
    return redirect(url_for('static', filename='uploads/' + filename))

@app.route('/ud/<sow_id>', methods=['GET','POST'])
def ud(sow_id):
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM dataset WHERE sow_id=%s',(sow_id,))
    data = cursor.fetchone()
    if request.method == 'GET':
        return render_template('update.html',data=data)
    else:
        sow_id = request.form['sow_id']
        rf_bfr = request.form['rf_before']
        mw_bfr = request.form['mw_before']
        rru_bfr = request.form['rru_before']
        rf_ud = request.form['rf_ud']
        mw_ud = request.form['mw_ud']
        rru_ud = request.form['rru_ud']
        activity = request.form['activity2']
        cursor.execute('UPDATE dataset SET activity=%s,rf_bfr=%s,mw_bfr=%s,rru_bfr=%s,rf_ud=%s,mw_ud=%s,rru_ud=%s WHERE sow_id=%s',
        (activity,rf_bfr,mw_bfr,rru_bfr,rf_ud,mw_ud,rru_ud,sow_id))
        mysql.commit()
        cursor.close()
        flash('Data berhasil diubah!','success')
        return redirect('/sign')

@app.route('/approve', methods=['GET','POST'])
def approve():
    cursor = mysql.cursor()
    if request.method == 'GET':
        nama_tp = session.get('nama_tp','')
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,oac FROM approve WHERE owner=%s AND status_tp='' ''', (nama_tp))
        rv = cursor.fetchall()
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,oac,tgl,status
            FROM approve WHERE owner=%s AND status!='' ''',(nama_tp) )
        vv = cursor.fetchall()
        mysql.commit()
        return render_template('approve.html', value=rv, values=vv)
    else:
        return redirect('/action/<sow_id>')

@app.route('/tsel',methods=['GET','POST'])  
def tsel():
    cursor = mysql.cursor()
    if request.method == 'GET':
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,oac FROM approve WHERE status_tp='approve' AND status='' ''')
        rv = cursor.fetchall()
        cursor.execute('''SELECT sow_id,kkst,capex,site_id,site_name,
            owner,sow,activity,rf_bfr,mw_bfr,rru_bfr,rf_aft,mw_aft,
            rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,oac,tgl,status
            FROM approve WHERE status='approve' OR status='reject' ''' )
        vv = cursor.fetchall()
        mysql.commit()
        return render_template('approve_Tsel.html', value=rv, values=vv)
    else:
        return redirect('/action/<sow_id>')


@app.route('/approvetsel/<sow_id>', methods=['GET'])
def approvetsel(sow_id):
    tanggal = datetime.now().strftime('%Y-%m-%d')
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM approve WHERE sow_id=%s',(sow_id,))
    cursor = mysql.cursor()
    cursor.execute('UPDATE approve SET status=%s, tgl=%s WHERE sow_id=%s',('approve',tanggal,sow_id))
    mysql.commit()
    cursor.close()
    return redirect('/tsel')


@app.route('/approved/<sow_id>', methods=['GET'])
def approved(sow_id):
    tanggal = datetime.now().strftime('%Y-%m-%d')
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM approve WHERE sow_id=%s',(sow_id,))
    cursor = mysql.cursor()
    cursor.execute('UPDATE approve SET status_tp=%s, tgl=%s WHERE sow_id=%s',('approve',tanggal,sow_id))
    mysql.commit()
    cursor.close()
    return redirect('/approve')

@app.route('/rejecttsel/<sow_id>', methods=['GET'])
def rejecttsel(sow_id):
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM approve WHERE sow_id=%s',(sow_id,))
    cursor = mysql.cursor()
    cursor.execute('UPDATE approve SET status=%s WHERE sow_id=%s',('reject',sow_id))
    mysql.commit()
    cursor.close()
    return redirect('/tsel')


@app.route('/reject/<sow_id>', methods=['GET'])
def reject(sow_id):
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM approve WHERE sow_id=%s',(sow_id,))
    cursor = mysql.cursor()
    cursor.execute('UPDATE approve SET status_tp=%s WHERE sow_id=%s',('reject',sow_id))
    mysql.commit()
    cursor.close()
    return redirect('/approve')


@app.route('/downloads', methods=['GET'])
def downloads():
    cursor = mysql.cursor()
    nama_tp = session.get('nama_tp','')
    query = "SELECT sow_id, kkst,capex,site_id,site_name,owner,sow,activity,rf_bfr, mw_bfr,rru_bfr,rf_aft,rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,tgl, status FROM approve WHERE owner=%s AND status='approve' "
    cursor.execute(query, nama_tp)
    data = cursor.fetchall()
    cursor.close()

    df = pd.DataFrame(data)

    excel_file_path = 'upload/data.xlsx'
    df.to_excel(excel_file_path, index=False)

    return send_file(excel_file_path, mimetype='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', download_name='bapt.xlsx', as_attachment=True)

@app.route('/downloadtsel', methods=['GET'])
def downloadtsel():
    cursor = mysql.cursor()
    query = "SELECT sow_id, kkst,capex,site_id,site_name,owner,sow,activity,rf_bfr, mw_bfr,rru_bfr,rf_aft,rru_aft,rf_ud,mw_ud,rru_ud,tgl_oac,tgl, status FROM approve WHERE status='approve' "
    cursor.execute(query)
    data = cursor.fetchall()
    cursor.close()
    df = pd.DataFrame(data)
    excel_file_path = 'upload/data.xlsx'
    df.to_excel(excel_file_path, index=False)

    return send_file(excel_file_path, mimetype='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', download_name='bapt.xlsx', as_attachment=True)


@app.route('/riwayat', methods=['GET','POST'])
def riwayat():
    if request.method == 'GET':
        nama_mitra = session.get('nama_mitra','')
        cursor = mysql.cursor()
        value = "SELECT * FROM approve WHERE mitra=%s"
        cursor.execute(value,nama_mitra)
        data = cursor.fetchall()
        mysql.commit()
        cursor.close()
        return render_template('riwayat.html', value=data)
    else:
        return render_template('riwayat.html')

@app.route('/updates/<sow_id>',methods=['GET','POST'])
def updates(sow_id):
    cursor = mysql.cursor()
    cursor.execute('SELECT * FROM approve WHERE sow_id=%s',(sow_id,))
    data = cursor.fetchone()
    if request.method == 'GET':
        return render_template('updates.html',data=data)
    else:
        sow_id = request.form['sow_id']
        rf_bfr = request.form['rf_before']
        mw_bfr = request.form['mw_before']
        rru_bfr = request.form['rru_before']
        rf_ud = request.form['rf_ud']
        mw_ud = request.form['mw_ud']
        rru_ud = request.form['rru_ud']
        activity = request.form['activity2']
        file = request.files['file']
        filename = secure_filename(f"{sow_id}_{file.filename}")
        file.save(os.path.join(app.config['UPLOAD_FOLDER'], filename))
        val = url_for('static', filename='uploads/' + filename)
        cursor.execute('UPDATE approve SET rf_bfr=%s,mw_bfr=%s,rru_bfr=%s,rf_ud=%s,mw_ud=%s,rru_ud=%s,activity=%s,oac=%s WHERE sow_id=%s',
        (rf_bfr,mw_bfr,rru_bfr,rf_ud,mw_ud,rru_ud,activity,val,sow_id))
        mysql.commit()
        cursor.close()
        flash('Data berhasil diubah!','success')
        return redirect('/riwayat')

@app.route('/repeat/<sow_id>', methods=['GET'])
def repeat(sow_id):
    if request.method == 'GET':
        cursor = mysql.cursor()
        cursor.execute('UPDATE approve SET status=%s, status_tp=%s WHERE sow_id=%s',
                       ('', '', sow_id))
        mysql.commit()
        cursor.close()
        flash('Data berhasil dikirim!')
        return redirect('/riwayat')
    else:
        return redirect('/riwayat')

@app.route('/search_riwayat', methods=['POST'])
def search_riwayat():
    filter = request.form['filter']
    nama_tp = session.get('nama_tp','')
    cursor = mysql.cursor()
    if filter == 'sow':
        sow_id = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE sow_id=%s ", (sow_id,))
    else:
        kkst = request.form['keyword']
        cursor.execute("SELECT * FROM approve WHERE kkst=%s", (kkst,))
        
    data2 = cursor.fetchall()
    mysql.commit()
    cursor.close()
    if data2:
        return render_template('search_riwayat.html', data2=data2) 
    else:
        flash('Data tidak ditemukan','danger')
        return redirect('/riwayat')



if __name__ =='__main__':
    app.run(debug=True)